﻿  package{
	  import flash.display.*;
	  import flash.text.TextField;	  
	  import flash.text.TextFormat;
	  import flash.text.TextFormatAlign;
	  import flash.events.*;
	  import flash.geom.Rectangle;
	  import flash.geom.Point;
	  
	  public class DialogConfirm extends MovieClip{
		  
		  public var flag_hasStageEvent = false;	//if stage event found or not
		  public var noDragFlag:Boolean = false;
		  public var type:String = "";
		  public var strTempData:String = "";
		  
		  //inner elements:
		  //mc_buttonOK
		  //txt_message
		  //txt_caption
		  
		  //constructor
		  public function DialogConfirm(){
 			  this.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown_handler);
			  this.txt_message.mouseEnabled = false;
			  
			  CommonFunctions.initSimpleButton(this.mc_buttonOK);
			  CommonFunctions.initSimpleButton(this.mc_buttonCancel);
			  
			  this.mc_buttonOK.addEventListener(MouseEvent.CLICK,buttonOkClick_handler);			  
			  this.mc_buttonOK.addEventListener(MouseEvent.MOUSE_DOWN,buttonDownClick_handler);
			  
			  this.mc_buttonCancel.addEventListener(MouseEvent.CLICK,buttonCancelClick_handler);
			  this.mc_buttonCancel.addEventListener(MouseEvent.MOUSE_DOWN,buttonDownClick_handler);
			  
		  }
		  
		  //------------------------------------------------------------------
		  // store temp data into dialog
		  public function storeTempData(data:String){
			  this.strTempData = data;
		  }
		  
		  //------------------------------------------------------------------
		  // get temp data from the dialog
		  public function getTempData(){
			  return(this.strTempData);
		  }
		  
		  //------------------------------------------------------------------
		  // position the dialog to parent center
		  public function positionParentCenter(){			  	
			  	var website = this.parent;
				if(website == null) return(false);
				var centerPoint:Point = website.centerPoint;			
				
				this.x = centerPoint.x - Math.floor((this.width)/2);				
				this.y = centerPoint.y - Math.floor((this.height)/2)-50;
		  }
		  
		  //------------------------------------------------------------------
		  // mouse down handler. start drag the dialog.
		  private function mouseDown_handler(event:MouseEvent){
			  if(this.noDragFlag == true){
				  this.noDragFlag = false;
				  return(false);
			  }
			  
			  if(this.flag_hasStageEvent == false){		//add once stage mouseup event
				  stage.addEventListener(MouseEvent.MOUSE_UP,stageMouseUp_handler);
				  this.flag_hasStageEvent = true;
			  }			  
			  var website = this.parent;			  			  
			  if(website == null) this.startDrag(false);
			  else{		//bound the drag area of the dialog to the parent.
			  	var rect1:Rectangle = website.boundRect;
			  	var rect:Rectangle = new Rectangle(rect1.x,rect1.y,rect1.width-this.width,rect1.height-this.height);
				this.startDrag(false,rect);
			  }
		  }
		  
		  //------------------------------------------------------------------
		  //stage mouse up handler. stop dragging
		  private function stageMouseUp_handler(event:MouseEvent){
			  this.stopDrag();
		  }
		  
		  //------------------------------------------------------------------
		  //event on button mouse down. stop the dragging.
		  public function buttonDownClick_handler(event:MouseEvent){
			  this.noDragFlag = true;
		  }
		  
		  //------------------------------------------------------------------
		  //format the messages
		  public function formatDialog(type:String=""){
			  var formatText:TextFormat = new TextFormat();
			  			  
			  formatText.align="center";
			  formatText.bold = false;
			  
			  this.txt_message.setTextFormat(formatText);			  
		  }
		  
		  //------------------------------------------------------------------
		  //event on button ok click. hide the dialog, and move the parent ok event.
		  public function buttonOkClick_handler(event:MouseEvent){
			  	var website = this.parent;
				website.confirmDialogCallback(this.type,true);
				this.visible = false;
		  }
		  
		  //------------------------------------------------------------------
		  //event on button cancel click. hide the button, and move the website cancel event/
		  public function buttonCancelClick_handler(event:MouseEvent){
			  var website = this.parent;
			  website.confirmDialogCallback(this.type,false);
			  this.visible = false;
		  }
		  
		  //------------------------------------------------------------------
		  //show the dialog with text
		  public function show(type:String,text:String){
			  this.type = type;
			  
			  this.txt_message.visible = true;			  				  
			  
			  positionParentCenter();
			  
			  this.txt_message.text = text;
			  			  
			  formatDialog(type);
			  this.visible = true;
		  }
		  
		  //------------------------------------------------------------------
		  //hide the dialog
		  public function hide(){
			  this.visible = false;
		  }
	  }   
  }